<?php
// public/track.php
session_start();
require_once __DIR__ . '/../config/db.php';

$pdo = get_pdo();

$errors = [];
$result = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $appId    = trim($_POST['application_id'] ?? '');
    $passport = trim($_POST['passport_number'] ?? '');

    if ($appId === '' || !ctype_digit($appId)) {
        $errors['application_id'] = 'شماره پرونده را به‌درستی وارد کنید.';
    }
    if ($passport === '') {
        $errors['passport_number'] = 'شماره پاسپورت الزامی است.';
    }

    if (!$errors) {
        $stmt = $pdo->prepare("
            SELECT a.*, ap.given_name, ap.family_name, ap.phone, ap.email,
                   p.passport_number,
                   t.visa_type, t.purpose_of_visit, t.entry_date, t.exit_date,
                   v.center, v.appointment_date, v.time_slot, v.payment_status
            FROM visa_applications a
            LEFT JOIN visa_applicants ap   ON ap.application_id = a.id
            LEFT JOIN visa_passports  p    ON p.application_id = a.id
            LEFT JOIN visa_travels    t    ON t.application_id = a.id
            LEFT JOIN visa_appointments v  ON v.application_id = a.id
            WHERE a.id = ? AND a.country = 'china' AND p.passport_number = ?
            LIMIT 1
        ");
        $stmt->execute([$appId, $passport]);
        $result = $stmt->fetch();

        if (!$result) {
            $errors['not_found'] = 'پرونده‌ای با این مشخصات یافت نشد. لطفاً شماره پرونده و پاسپورت را بررسی کنید.';
        }
    }
}

function e($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>پیگیری وضعیت ویزای چین</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body { font-family:sans-serif; background:#f5f7fb; margin:0; padding:0; }
        .container {
            max-width:720px; margin:40px auto; background:#fff;
            border-radius:12px; padding:24px 28px;
            box-shadow:0 6px 18px rgba(0,0,0,0.08);
        }
        h1 { font-size:22px; margin-bottom:6px; text-align:right; }
        .subtitle { font-size:13px; color:#666; margin-bottom:18px; text-align:right; }
        .badge {
            display:inline-block; background:#eaf1ff; color:#1b46c2;
            padding:4px 10px; border-radius:999px; font-size:11px; margin-bottom:10px;
        }
        .form-group { margin-bottom:14px; display:flex; flex-direction:column; }
        label { font-size:13px; margin-bottom:4px; color:#333; }
        input[type="text"], input[type="number"] {
            padding:8px 10px; font-size:13px; border:1px solid #ccd2e0;
            border-radius:6px; outline:none; direction:ltr;
        }
        input:focus {
            border-color:#3563e9; box-shadow:0 0 0 2px rgba(53,99,233,0.15);
        }
        .btn {
            border:none; padding:9px 18px; border-radius:8px;
            font-size:13px; cursor:pointer; background:#3563e9; color:#fff;
        }
        .btn:hover { background:#2749b4; }
        .error { color:#d93025; font-size:11px; margin-top:3px; }
        .global-error {
            background:#ffe5e5; border:1px solid #f5b5b5; color:#a30000;
            padding:10px 12px; border-radius:8px; font-size:12px; margin-bottom:14px;
        }
        .result-box {
            margin-top:20px; padding:14px 16px;
            border-radius:10px; border:1px solid #e0e4ef; background:#fafbff;
        }
        .result-box h2 { margin:0 0 10px 0; font-size:16px; }
        .row { font-size:13px; margin-bottom:4px; }
        .label { font-weight:bold; color:#333; }
        .status-pill {
            display:inline-block; padding:2px 8px; border-radius:999px;
            font-size:11px; margin-top:4px;
        }
        .st-draft { background:#fff4e5; color:#b25b00; border:1px solid #f0c78a; }
        .st-submitted { background:#e6f1ff; color:#1347b0; border:1px solid #aac5ff; }
        .st-booked { background:#e6ffed; color:#146c2e; border:1px solid #9be7b0; }
        a.link-home { font-size:12px; text-decoration:none; color:#3563e9; }
    </style>
</head>
<body>

<div class="container">
    <div class="badge">پیگیری پرونده ویزای چین 🇨🇳</div>
    <h1>پیگیری وضعیت و زمان مراجعه</h1>
    <div class="subtitle">
        برای مشاهده وضعیت پرونده و زمان نوبت، شماره پرونده و شماره پاسپورت را وارد کنید.
    </div>

    <?php if (!empty($errors['not_found'])): ?>
        <div class="global-error"><?= e($errors['not_found']) ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="form-group">
            <label>شماره پرونده (Application ID)</label>
            <input type="text" name="application_id" value="<?= e($_POST['application_id'] ?? '') ?>">
            <?php if (!empty($errors['application_id'])): ?>
                <div class="error"><?= e($errors['application_id']) ?></div>
            <?php endif; ?>
        </div>

        <div class="form-group">
            <label>شماره پاسپورت (لاتین)</label>
            <input type="text" name="passport_number" value="<?= e($_POST['passport_number'] ?? '') ?>">
            <?php if (!empty($errors['passport_number'])): ?>
                <div class="error"><?= e($errors['passport_number']) ?></div>
            <?php endif; ?>
        </div>

        <button type="submit" class="btn">نمایش وضعیت</button>
    </form>

    <?php if ($result): ?>
        <div class="result-box">
            <h2>خلاصه پرونده</h2>
            <div class="row">
                <span class="label">شماره پرونده:</span>
                <span>#<?= e($result['id']) ?></span>
            </div>
            <div class="row">
                <span class="label">نام متقاضی:</span>
                <span><?= e($result['given_name'] . ' ' . $result['family_name']) ?></span>
            </div>
            <div class="row">
                <span class="label">وضعیت پرونده:</span>
                <?php
                $status = $result['status'];
                $cls = 'st-draft'; $txt = 'در حال تکمیل';
                if ($status === 'submitted') { $cls = 'st-submitted'; $txt = 'ثبت شده'; }
                if ($status === 'appointment_booked') { $cls = 'st-booked'; $txt = 'نوبت رزرو شده'; }
                ?>
                <span class="status-pill <?= $cls ?>"><?= e($txt) ?></span>
            </div>

            <?php if (!empty($result['center']) && !empty($result['appointment_date'])): ?>
                <hr style="border:none;border-top:1px dashed #dde2f0;margin:10px 0;">
                <h2 style="font-size:14px;">جزئیات نوبت</h2>
                <div class="row">
                    <span class="label">مرکز مراجعه:</span>
                    <span><?= e($result['center']) ?></span>
                </div>
                <div class="row">
                    <span class="label">تاریخ:</span>
                    <span><?= e($result['appointment_date']) ?></span>
                </div>
                <div class="row">
                    <span class="label">بازه زمانی:</span>
                    <span><?= e($result['time_slot']) ?></span>
                </div>
                <div class="row">
                    <span class="label">وضعیت پرداخت:</span>
                    <span><?= e($result['payment_status']) ?></span>
                </div>
            <?php else: ?>
                <div class="row" style="margin-top:8px;">
                    هنوز نوبت تحویل مدارک برای این پرونده ثبت نشده است.
                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <div style="margin-top:16px;text-align:left;">
        <a href="index.php" class="link-home">← بازگشت به صفحه اصلی سامانه</a>
    </div>
</div>

</body>
</html>
