<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/otp.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php'); exit;
}

// CSRF
if (empty($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
    $_SESSION['login_error'] = 'درخواست نامعتبر است. دوباره تلاش کنید.';
    header('Location: index.php'); exit;
}

$email = strtolower(trim((string)($_SESSION['otp_email_pending'] ?? '')));
$code  = trim((string)($_POST['code'] ?? ''));

$code = strtr($code, [
  '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9',
  '٠'=>'0','١'=>'1','٢'=>'2','٣'=>'3','٤'=>'4','٥'=>'5','٦'=>'6','٧'=>'7','٨'=>'8','٩'=>'9',
]);


if (!$email) {
    $_SESSION['login_error'] = 'ابتدا ایمیل را وارد کنید.';
    header('Location: index.php'); exit;
}

if (!preg_match('/^[0-9]{6}$/', $code)) {
    $_SESSION['login_error'] = 'کد ۶ رقمی معتبر وارد کنید.';
    header('Location: index.php'); exit;
}

$vr = otp_verify($email, $code);
if (!$vr['ok']) {
    $_SESSION['login_error'] = $vr['error'] ?? 'کد صحیح نیست.';
    header('Location: index.php'); exit;
}

// لاگین موفق
login_as($email);
unset($_SESSION['otp_email_pending']);

$pdo = get_pdo();

// پیدا کردن آخرین پرونده مربوط به ایمیل
$stmt = $pdo->prepare("
    SELECT a.id, a.current_step
    FROM visa_applications a
    INNER JOIN visa_applicants ap ON ap.application_id = a.id
    WHERE ap.email = ?
    ORDER BY a.updated_at DESC, a.id DESC
    LIMIT 1
");
$stmt->execute([$email]);
$row = $stmt->fetch();

if ($row) {
    $_SESSION['china_application_id'] = (int)$row['id'];
    $step = (int)($row['current_step'] ?? 1);
    if ($step < 1 || $step > 6) $step = 1;
    header("Location: china_step{$step}.php"); exit;
}

// اگر پرونده‌ای نبود، یکی بساز
$pdo->beginTransaction();
try {
    $stmt = $pdo->prepare("
        INSERT INTO visa_applications (country_code, visa_type, current_step, status, created_at, updated_at)
        VALUES ('CN', NULL, 1, 'draft', NOW(), NOW())
    ");
    $stmt->execute();
    $appId = (int)$pdo->lastInsertId();

    $stmt = $pdo->prepare("
        INSERT INTO visa_applicants (application_id, family_name, given_name, middle_name, gender, dob, nationality, birth_country, marital_status, phone, email, created_at, updated_at)
        VALUES (?, '', '', '', NULL, NULL, '', '', '', '', ?, NOW(), NOW())
    ");
    $stmt->execute([$appId, $email]);

    $pdo->commit();

    $_SESSION['china_application_id'] = $appId;
    header("Location: china_step1.php"); exit;
} catch (Throwable $e) {
    $pdo->rollBack();
    $_SESSION['login_error'] = 'ساخت پرونده جدید ناموفق بود.';
    header('Location: index.php'); exit;
}
