<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../includes/otp.php';
require_once __DIR__ . '/../includes/mailer.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php'); exit;
}

// CSRF
if (empty($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
    $_SESSION['login_error'] = 'درخواست نامعتبر است. دوباره تلاش کنید.';
    header('Location: index.php'); exit;
}

$email = strtolower(trim((string)($_POST['email'] ?? '')));
if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $_SESSION['login_error'] = 'ایمیل معتبر وارد کنید.';
    header('Location: index.php'); exit;
}

$res = otp_issue($email);
if (!$res['ok']) {
    $_SESSION['login_error'] = $res['error'] ?? 'خطا در تولید کد.';
    header('Location: index.php'); exit;
}

// ارسال ایمیل
$sent = send_otp_email($email, $res['code']);
if (!$sent) {
    $_SESSION['login_error'] = 'ارسال ایمیل ناموفق بود. (Mailer/SMTP را بررسی کنید)';
    header('Location: index.php'); exit;
}

$_SESSION['otp_email_pending'] = $email;
$_SESSION['login_notice'] = 'کد ورود به ایمیل شما ارسال شد.';
header('Location: index.php'); exit;
