<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/db.php';

// اگر لاگین هست، مستقیم ادامه بده
if (is_logged_in()) {
    $email = $_SESSION['auth_email'];
    try {
        $pdo = get_pdo();
        $stmt = $pdo->prepare("
            SELECT a.id, a.current_step
            FROM visa_applications a
            INNER JOIN visa_applicants ap ON ap.application_id = a.id
            WHERE ap.email = ?
            ORDER BY a.updated_at DESC, a.id DESC
            LIMIT 1
        ");
        $stmt->execute([$email]);
        $row = $stmt->fetch();
        if ($row) {
            $_SESSION['china_application_id'] = (int)$row['id'];
            $step = (int)($row['current_step'] ?? 1);
            if ($step < 1 || $step > 6) $step = 1;
            header("Location: china_step{$step}.php"); exit;
        }
        // اگر لاگین هست ولی پرونده ندارد، به مرحله 1 می‌رود
        header("Location: china_step1.php"); exit;
    } catch (Throwable $e) {
        // اگر DB مشکل داشت، همانجا فرم را نشان می‌دهیم
    }
}

$csrf = csrf_token();
$pending = $_SESSION['otp_email_pending'] ?? '';
$err = $_SESSION['login_error'] ?? '';
$note = $_SESSION['login_notice'] ?? '';
unset($_SESSION['login_error'], $_SESSION['login_notice']);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>ورود | سامانه رزرو ویزا</title>
  <style>
    body{font-family:sans-serif;background:#f5f7fb;margin:0;padding:0}
    .card{max-width:420px;margin:56px auto;background:#fff;border-radius:14px;box-shadow:0 10px 30px rgba(0,0,0,.08);padding:22px}
    h1{font-size:18px;margin:0 0 14px}
    label{display:block;margin:10px 0 6px;font-size:13px;color:#444}
    input{width:100%;padding:12px;border:1px solid #ddd;border-radius:10px;font-size:14px;outline:none}
    input:focus{border-color:#4f7cff}
    .btn{width:100%;padding:12px;border:none;border-radius:10px;background:#4f7cff;color:#fff;font-size:14px;cursor:pointer;margin-top:12px}
    .muted{color:#666;font-size:12px;line-height:1.7;margin-top:12px}
    .msg{padding:10px;border-radius:10px;margin:10px 0;font-size:13px}
    .err{background:#ffe9e9;color:#b00020;border:1px solid #ffc6c6}
    .ok{background:#eafff0;color:#0b6b2a;border:1px solid #bdf2cd}
  </style>
</head>
<body>
  <div class="card">
    <h1>ورود با کد یکبارمصرف (OTP)</h1>

    <?php if ($err): ?>
      <div class="msg err"><?= htmlspecialchars($err) ?></div>
    <?php endif; ?>

    <?php if ($note): ?>
      <div class="msg ok"><?= htmlspecialchars($note) ?></div>
    <?php endif; ?>

    <?php if (!$pending): ?>
      <form method="post" action="otp_request.php" autocomplete="on">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
        <label>ایمیل</label>
        <input name="email" type="email" placeholder="name@example.com" required>
        <button class="btn" type="submit">ارسال کد</button>
        <div class="muted">کد ۶ رقمی به ایمیل شما ارسال می‌شود (اعتبار: ۱۰ دقیقه).</div>
      </form>
    <?php else: ?>
      <div class="muted">کد به ایمیل <b><?= htmlspecialchars($pending) ?></b> ارسال شد.</div>
      <form method="post" action="otp_verify.php" autocomplete="one-time-code">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
        <label>کد ۶ رقمی</label>
        <input name="code" inputmode="numeric" pattern="[0-9]{6}" maxlength="6" placeholder="------" required>
        <button class="btn" type="submit">ورود</button>
      </form>

      <form method="post" action="otp_request.php" style="margin-top:10px;">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
        <input type="hidden" name="email" value="<?= htmlspecialchars($pending) ?>">
        <button class="btn" type="submit" style="background:#111;">ارسال مجدد کد</button>
      </form>

      <div class="muted">اگر ایمیل را اشتباه وارد کرده‌اید، صفحه را رفرش کنید و دوباره وارد شوید.</div>
    <?php endif; ?>
  </div>
</body>
</html>
