<?php
// public/china_step5_submit.php
require_once __DIR__ . '/../config/auth.php';
require_login();
csrf_token();
require_once __DIR__ . '/../config/db.php';

if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
    die('Invalid CSRF token');
}

$errors = [];
$applicationId = $_SESSION['china_application_id'];

// کاربر باید تیک تأیید را بزند
if (empty($_POST['confirm']) || $_POST['confirm'] !== '1') {
    $errors['confirm'] = 'برای ثبت نهایی، لازم است تیک تأیید اطلاعات را بزنید.';
}

if ($errors) {
    $_SESSION['form_errors'] = $errors;
    header('Location: china_step5.php');
    exit;
}

$pdo = get_pdo();

$stmt = $pdo->prepare("
    UPDATE visa_applications
    SET status = 'submitted',
        current_step = 5,
        updated_at = NOW()
    WHERE id = ?
");
$stmt->execute([$applicationId]);

// اگر ستون submitted_at را اضافه کرده باشی، می‌توانی از این نسخه استفاده کنی:
/*
$stmt = $pdo->prepare("
    UPDATE visa_applications
    SET status = 'submitted',
        current_step = 5,
        updated_at = NOW(),
        submitted_at = NOW()
    WHERE id = ?
");
$stmt->execute([$applicationId]);
*/

$_SESSION['success_message'] = 'درخواست شما ثبت نهایی شد. حالا زمان مراجعه و روش پرداخت را انتخاب کنید.';
header('Location: china_step6.php');
exit;
