<?php
// public/china_step2_submit.php
require_once __DIR__ . '/../config/auth.php';
require_login();
csrf_token();
require_once __DIR__ . '/../config/db.php';

// اگر هنوز application نداریم → برگرد مرحله ۱
if (empty($_SESSION['china_application_id'])) {
    header('Location: china_step1.php');
    exit;
}

// CSRF check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
    die('Invalid CSRF token');
}

$errors = [];
$old    = [];

// فیلدها
$fields = ['passport_number','place_of_issue','date_of_issue','date_of_expiry'];
foreach ($fields as $f) {
    $old[$f] = trim($_POST[$f] ?? '');
}

// اعتبارسنجی
// شماره پاسپورت
if ($old['passport_number'] === '' || !preg_match('/^[A-Za-z0-9]{5,20}$/', $old['passport_number'])) {
    $errors['passport_number'] = 'شماره پاسپورت الزامی است و باید فقط شامل حروف و اعداد لاتین باشد.';
}

// محل صدور
if ($old['place_of_issue'] === '' || !preg_match('/^[A-Za-z\s]{2,}$/', $old['place_of_issue'])) {
    $errors['place_of_issue'] = 'محل صدور را به صورت لاتین وارد کنید (مثلاً TEHRAN).';
}

// تاریخ‌ها
$issue = DateTime::createFromFormat('Y-m-d', $old['date_of_issue']);
$issueErr = DateTime::getLastErrors();
if ($issue === false || $issueErr['warning_count'] > 0 || $issueErr['error_count'] > 0) {
    $errors['date_of_issue'] = 'تاریخ صدور نامعتبر است.';
}

$expiry = DateTime::createFromFormat('Y-m-d', $old['date_of_expiry']);
$expErr = DateTime::getLastErrors();
if ($expiry === false || $expErr['warning_count'] > 0 || $expErr['error_count'] > 0) {
    $errors['date_of_expiry'] = 'تاریخ انقضاء نامعتبر است.';
}

if (empty($errors['date_of_issue']) && empty($errors['date_of_expiry'])) {
    // انقضا باید بعد از صدور باشد
    if ($expiry <= $issue) {
        $errors['date_of_expiry'] = 'تاریخ انقضاء باید بعد از تاریخ صدور باشد.';
    }

    // انقضا باید حداقل ۶ ماه بعد از امروز باشد
    $now = new DateTime();
    $minExpiry = (clone $now)->modify('+6 months');
    if ($expiry < $minExpiry) {
        $errors['date_of_expiry'] = 'اعتبار پاسپورت کمتر از ۶ ماه است.';
    }
}

// اگر خطا داریم → برگردیم به فرم
if ($errors) {
    $_SESSION['form_errors'] = $errors;
    $_SESSION['form_old']    = $old;
    header('Location: china_step2.php');
    exit;
}

// ذخیره در دیتابیس
$pdo = get_pdo();
$applicationId = $_SESSION['china_application_id'];

$pdo->beginTransaction();

try {
    // آیا پاسپورت قبلاً موجود است؟
    $stmt = $pdo->prepare("SELECT id FROM visa_passports WHERE application_id = ?");
    $stmt->execute([$applicationId]);
    $existingId = $stmt->fetchColumn();

    if ($existingId) {
        $stmt = $pdo->prepare("
            UPDATE visa_passports
            SET passport_number = ?, place_of_issue = ?, date_of_issue = ?, date_of_expiry = ?, updated_at = NOW()
            WHERE application_id = ?
        ");
        $stmt->execute([
            $old['passport_number'],
            $old['place_of_issue'],
            $old['date_of_issue'],
            $old['date_of_expiry'],
            $applicationId
        ]);
    } else {
        $stmt = $pdo->prepare("
            INSERT INTO visa_passports
                (application_id, passport_number, place_of_issue, date_of_issue, date_of_expiry, created_at, updated_at)
            VALUES (?,?,?,?,?,NOW(),NOW())
        ");
        $stmt->execute([
            $applicationId,
            $old['passport_number'],
            $old['place_of_issue'],
            $old['date_of_issue'],
            $old['date_of_expiry'],
        ]);
    }

    // آپدیت مرحله فعلی درخواست
    $stmt = $pdo->prepare("UPDATE visa_applications SET current_step = 2, updated_at = NOW() WHERE id = ?");
    $stmt->execute([$applicationId]);

    $pdo->commit();
} catch (Exception $e) {
    $pdo->rollBack();
    die('Database error: ' . $e->getMessage());
}

header('Location: china_step3.php');
exit;
