<?php
// public/china_step1.php
require_once __DIR__ . '/../config/auth.php';
require_login();
csrf_token();
// ساخت CSRF token اگر وجود نداشته باشد
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// خواندن خطاها و داده‌های قبلی از سشن
$errors = $_SESSION['form_errors'] ?? [];
$old    = $_SESSION['form_old'] ?? [];

// پاک کردن تا برای رفرش‌های بعدی دوباره تکرار نشن
unset($_SESSION['form_errors'], $_SESSION['form_old']);
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرحله ۱ - اطلاعات شخصی ویزای چین</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        body {
            font-family: sans-serif;
            background: #f5f7fb;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 720px;
            margin: 40px auto;
            background: #ffffff;
            border-radius: 12px;
            padding: 24px 28px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.08);
        }
        h1 {
            font-size: 22px;
            margin-bottom: 6px;
            text-align: right;
        }
        .subtitle {
            font-size: 13px;
            color: #666;
            margin-bottom: 20px;
            text-align: right;
        }
        .form-row {
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
        }
        .form-group {
            flex: 1 1 48%;
            display: flex;
            flex-direction: column;
            margin-bottom: 14px;
        }
        .form-group.full {
            flex: 1 1 100%;
        }
        label {
            font-size: 13px;
            margin-bottom: 4px;
            color: #333;
        }
        label span.en {
            font-size: 11px;
            color: #777;
        }
        input[type="text"],
        input[type="email"],
        input[type="date"],
        select {
            padding: 8px 10px;
            font-size: 13px;
            border: 1px solid #ccd2e0;
            border-radius: 6px;
            outline: none;
            direction: ltr;
        }
        select {
            direction: ltr;
        }
        input:focus,
        select:focus {
            border-color: #3563e9;
            box-shadow: 0 0 0 2px rgba(53,99,233,0.15);
        }
        .error {
            color: #d93025;
            font-size: 11px;
            margin-top: 3px;
        }
        .global-error {
            background: #ffe5e5;
            border: 1px solid #f5b5b5;
            color: #a30000;
            padding: 10px 12px;
            border-radius: 8px;
            font-size: 12px;
            margin-bottom: 14px;
        }
        .helper {
            font-size: 11px;
            color: #888;
            margin-top: 2px;
        }
        .btn-row {
            display: flex;
            justify-content: flex-end;
            margin-top: 18px;
        }
        button[type="submit"] {
            background: #3563e9;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            font-size: 13px;
            cursor: pointer;
        }
        button[type="submit"]:hover {
            background: #2749b4;
        }
        .badge-country {
            display: inline-block;
            background: #eaf1ff;
            color: #1b46c2;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 11px;
            margin-bottom: 10px;
        }
        @media (max-width: 600px) {
            .form-group {
                flex: 1 1 100%;
            }
            .container {
                margin: 16px;
                padding: 18px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="badge-country">🇨🇳 فرم ویزای چین - مرحله ۱ از ۶</div>
    <h1>اطلاعات شخصی متقاضی</h1>
    <div class="subtitle">
        لطفاً اطلاعات را دقیقاً مطابق پاسپورت انگلیسی خود وارد کنید. حروف فقط به صورت لاتین وارد شوند.
    </div>

    <?php if (!empty($errors)): ?>
        <div class="global-error">
            لطفاً خطاهای مشخص‌شده در فرم را اصلاح کنید.
        </div>
    <?php endif; ?>

    <form method="post" action="china_step1_submit.php" novalidate>
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'] ?? '') ?>">

        <div class="form-row">
            <div class="form-group">
                <label>
                    نام خانوادگی (مطابق پاسپورت)
                    <span class="en">Family Name (Surname)</span>
                </label>
                <input type="text" name="family_name"
                       value="<?= htmlspecialchars($old['family_name'] ?? '') ?>"
                       placeholder="REZAIE">
                <?php if (!empty($errors['family_name'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['family_name']) ?></div>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label>
                    نام (مطابق پاسپورت)
                    <span class="en">Given Name</span>
                </label>
                <input type="text" name="given_name"
                       value="<?= htmlspecialchars($old['given_name'] ?? '') ?>"
                       placeholder="ALI">
                <?php if (!empty($errors['given_name'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['given_name']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    نام میانی (در صورت وجود)
                    <span class="en">Middle Name (Optional)</span>
                </label>
                <input type="text" name="middle_name"
                       value="<?= htmlspecialchars($old['middle_name'] ?? '') ?>">
                <?php if (!empty($errors['middle_name'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['middle_name']) ?></div>
                <?php endif; ?>
                <div class="helper">اگر در پاسپورت نام میانی ندارید، این فیلد را خالی بگذارید.</div>
            </div>

            <div class="form-group">
                <label>
                    جنسیت
                    <span class="en">Gender</span>
                </label>
                <select name="gender">
                    <option value="">انتخاب کنید</option>
                    <option value="male"   <?= (isset($old['gender']) && $old['gender']==='male')   ? 'selected' : '' ?>>Male</option>
                    <option value="female" <?= (isset($old['gender']) && $old['gender']==='female') ? 'selected' : '' ?>>Female</option>
                </select>
                <?php if (!empty($errors['gender'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['gender']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    تاریخ تولد
                    <span class="en">Date of Birth</span>
                </label>
                <input type="date" name="dob"
                       value="<?= htmlspecialchars($old['dob'] ?? '') ?>">
                <?php if (!empty($errors['dob'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['dob']) ?></div>
                <?php endif; ?>
                <div class="helper">فرمت: YYYY-MM-DD (مثال: 1980-01-01)</div>
            </div>

            <div class="form-group">
                <label>
                    وضعیت تأهل
                    <span class="en">Marital Status</span>
                </label>
                <select name="marital_status">
                    <option value="">انتخاب کنید</option>
                    <option value="single"   <?= (isset($old['marital_status']) && $old['marital_status']==='single')   ? 'selected' : '' ?>>Single</option>
                    <option value="married"  <?= (isset($old['marital_status']) && $old['marital_status']==='married')  ? 'selected' : '' ?>>Married</option>
                    <option value="divorced" <?= (isset($old['marital_status']) && $old['marital_status']==='divorced') ? 'selected' : '' ?>>Divorced</option>
                    <option value="widowed"  <?= (isset($old['marital_status']) && $old['marital_status']==='widowed')  ? 'selected' : '' ?>>Widowed</option>
                </select>
                <?php if (!empty($errors['marital_status'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['marital_status']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    تابعیت (ملیت)
                    <span class="en">Nationality</span>
                </label>
                <select name="nationality">
                    <option value="">انتخاب کنید</option>
                    <option value="IRAN" <?= (isset($old['nationality']) ? $old['nationality']==='IRAN' : true) ? 'selected' : '' ?>>IRAN</option>
                    <!-- بعداً می‌تونی کشور‌های دیگه اضافه کنی -->
                </select>
                <?php if (!empty($errors['nationality'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['nationality']) ?></div>
                <?php endif; ?>
            </div>

            <div class="form-group">
                <label>
                    کشور محل تولد
                    <span class="en">Country of Birth</span>
                </label>
                <select name="birth_country">
                    <option value="">انتخاب کنید</option>
                    <option value="IRAN" <?= (isset($old['birth_country']) ? $old['birth_country']==='IRAN' : true) ? 'selected' : '' ?>>IRAN</option>
                </select>
                <?php if (!empty($errors['birth_country'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['birth_country']) ?></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label>
                    شماره موبایل
                    <span class="en">Mobile Phone</span>
                </label>
                <input type="text" name="phone"
                       value="<?= htmlspecialchars($old['phone'] ?? '') ?>"
                       placeholder="09xxxxxxxxx">
                <?php if (!empty($errors['phone'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['phone']) ?></div>
                <?php endif; ?>
                <div class="helper">لطفاً شماره‌ای وارد کنید که همیشه در دسترس است.</div>
            </div>

            <div class="form-group">
                <label>
                    ایمیل
                    <span class="en">Email Address</span>
                </label>
                <input type="email" name="email"
                       value="<?= htmlspecialchars($old['email'] ?? '') ?>"
                       placeholder="example@email.com">
                <?php if (!empty($errors['email'])): ?>
                    <div class="error"><?= htmlspecialchars($errors['email']) ?></div>
                <?php endif; ?>
                <div class="helper">رسید و لینک پیگیری به این ایمیل ارسال می‌شود.</div>
            </div>
        </div>

        <div class="btn-row">
            <button type="submit">ذخیره و ادامه به مرحله بعد (اطلاعات پاسپورت)</button>
        </div>
    </form>
</div>

</body>
</html>
