<?php
// includes/mailer.php
// ارسال ایمیل OTP. ترجیحاً با PHPMailer.
// اگر PHPMailer نصب نباشد، به mail() برمی‌گردد (ممکن است روی بعضی هاست‌ها کار نکند).

function send_otp_email(string $toEmail, string $code): bool
{
    $cfg = require __DIR__ . '/../config/mail.php';

    $subject = 'کد ورود سامانه ویزا';
    $body = "کد ورود شما: {$code}\n\nاین کد فقط 10 دقیقه معتبر است.\nاگر شما درخواست نداده‌اید، این ایمیل را نادیده بگیرید.";

    // 1) PHPMailer (اگر موجود بود)
    $autoload = __DIR__ . '/../vendor/autoload.php';
    if (file_exists($autoload)) {
        require_once $autoload;
    }

    if (class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
        try {
            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            $mail->CharSet = 'UTF-8';
            $mail->isSMTP();
            $mail->Host = $cfg['host'];
            $mail->SMTPAuth = true;
            $mail->Username = $cfg['username'];
            $mail->Password = $cfg['password'];
            $mail->Port = (int)$cfg['port'];

            if (($cfg['secure'] ?? 'ssl') === 'tls') {
                $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
            } else {
                $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_SMTPS;
            }

            $mail->setFrom($cfg['from_email'], $cfg['from_name'] ?? 'Visa Panel');
            $mail->addAddress($toEmail);
            $mail->Subject = $subject;
            $mail->Body = $body;

            return $mail->send();
        } catch (Throwable $e) {
            // در حالت شکست، می‌افتیم روی mail()
        }
    }

    // 2) fallback: mail()
    $headers = [];
    $from = $cfg['from_email'] ?? 'no-reply@localhost';
    $headers[] = "From: " . $from;
    $headers[] = "MIME-Version: 1.0";
    $headers[] = "Content-Type: text/plain; charset=UTF-8";
    $headersStr = implode("\r\n", $headers);

    // subject encoding (optional)
    if (function_exists('mb_encode_mimeheader')) {
        $subject = mb_encode_mimeheader($subject, 'UTF-8');
    }

    return @mail($toEmail, $subject, $body, $headersStr);
}
