<?php
// config/auth.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function csrf_token(): string {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
    }
    return $_SESSION['csrf_token'];
}

function is_logged_in(): bool {
    return !empty($_SESSION['auth_email']);
}

function require_login(): void {
    if (!is_logged_in()) {
        header('Location: index.php');
        exit;
    }
}

function login_as(string $email): void {
    $_SESSION['auth_email'] = strtolower(trim($email));
}

function logout_user(): void {
    $_SESSION = [];
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            (bool)$params["secure"], (bool)$params["httponly"]
        );
    }
    session_destroy();
}
